#!/bin/bash

# Run it like: ./launch.sh ./igRGOUE -s &

if [ $# -eq 0 ]; then
    echo "Error: No program specified."
    echo "Usage: $0 /path/to/program [args...]"
    exit 1
fi

# Optional: Log restarts for debugging
echo "Starting restart loop for: $*"
echo "Press Ctrl+C to stop the loop."

while true; do
    "$@"
    exit_code=$?

    if [ $exit_code -eq 0 ]; then
        echo "Program exited normally (exit code 0). Not restarting."
        exit 0
    else
        echo "Program exited with code $exit_code. Restarting in 5 seconds..."
        sleep 5  # Prevent rapid looping if the program crashes immediately
    fi
done
